/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.api.common.attribute;

import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;

public interface ICombinedAttribute {
    public double getModifiedValue(IAttributeProvider var1, double var2);

    public double value(IAttributeProvider var1);

    public float floatValue(IAttributeProvider var1);

    public int intValue(IAttributeProvider var1);

    public static ICombinedAttribute of(IAttributeId ... keys) {
        return new SimpleCombinedAttribute(keys);
    }

    public static class SimpleCombinedAttribute
    implements ICombinedAttribute {
        private final IAttributeId[] keys;

        private SimpleCombinedAttribute(IAttributeId[] keys) {
            this.keys = keys;
            if (keys.length < 2) {
                throw new IllegalArgumentException("Cannot combine <2 attributes");
            }
        }

        @Override
        public double value(IAttributeProvider provider) {
            double result = 1.0;
            for (IAttributeId id : this.keys) {
                result *= provider.getAttributeValue(id);
            }
            return result;
        }

        @Override
        public float floatValue(IAttributeProvider provider) {
            return (float)this.value(provider);
        }

        @Override
        public int intValue(IAttributeProvider provider) {
            double result = this.value(provider);
            return (int)Math.round(result);
        }

        @Override
        public double getModifiedValue(IAttributeProvider provider, double value) {
            for (IAttributeId id : this.keys) {
                value = provider.getAttribute(id).getModifiedValue(value);
            }
            return value;
        }
    }
}

